package gov.va.genisis2.dto;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

/**
 * Data Transfer Object (DTO) to transfer user type related details
 * 
 * @author Prasad Thummalapalli
 *
 */
@XmlRootElement(name = "userType")
@JsonInclude(Include.NON_NULL)
public class UserTypeDTO implements Serializable {

	/**
	 * serialVersionUID field
	 */
	private static final long serialVersionUID = -2479415126066507972L;
	
	private int userTypeId;
	private String userTypeDesc;

	/**
	 * @return the userTypeId
	 */
	public int getUserTypeId() {
		return userTypeId;
	}

	/**
	 * @param userTypeId
	 *            the userTypeId to set
	 */
	public void setUserTypeId(int userTypeId) {
		this.userTypeId = userTypeId;
	}

	/**
	 * @return the userTypeDesc
	 */
	public String getUserTypeDesc() {
		return userTypeDesc;
	}

	/**
	 * @param userTypeDesc
	 *            the userTypeDesc to set
	 */
	public void setUserTypeDesc(String userTypeDesc) {
		this.userTypeDesc = userTypeDesc;
	}
}